/*
 * 01-09-2023
 * Bat detector code for generation of heterodyne mixer signal (10-99kHz) and display the frequency and battery level display. The display used is a SSd1306 72x40 pixel.
 * Code by PE1PWF based on the adafruit display example code, frequency generation by the toneAC library by Tim Eckel
 * Font used is Ubuntu Mono converted to 30pt/40pixels with https://rop.nl/truetype2gfx/
 */

#include <toneAC.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>


#define SCREEN_WIDTH 128 //  display width, in pixels. (the display is actually 72x40, using those setting the display was messed up, probably not the right driver) 
#define SCREEN_HEIGHT 64 //  display height, in pixels (these settings seem to work as long as you use and offset of 28 to the right and 12 from the top)
#include <Fonts/UbuntuMono_B30pt7b.h>

// Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);


//Frequency generator Variables//
int outpin = 13;
float Frequency = 0;
int Display = 0; 
int Bar = 0;

//-------------------------------
void setup() 
{
  Serial.begin(19200);
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // Address 0x3D for 128x64
    Serial.println(F("SSD1306 allocation failed"));
    for(;;);

  toneAC (99000);  //set outout frequency first to have a source on the mixer which prevents humming
  }
  delay(100);
  toneAC(99000);  
  display.dim(true);
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(28, 28);
  display.println("PE1PWF");
  display.display(); 
  delay(500);
  display.setCursor(28, 41);
  display.println("Heterodyne");
  display.display(); 
  delay(500);
  display.setCursor(28, 54);
  display.println("Batdetector");
  display.display(); 
  delay(3000);
 
}
void loop()
{
  
  //Frequency Output//
  //----------------------------------------
//  Frequency = analogRead(A0);
  Frequency = map(analogRead(A3), 0, 1023, 10000, 99000); // translates the full potentiometer sweep voltage to 10-99kHz frequency range. 
      {Display = round((Frequency/1000));} //displays frequency in KHz

   
          //Serial.println (analogInPin0); //some lines for debugging purposes
          //Serial.println (Frequency);
          // Serial.println (Display);

  delay(100);
  display.clearDisplay();
    display.setFont(&UbuntuMono_B30pt7b); //this if the maximum font size using 40 pixels high in a nice clean font (fonts use a lot of memory).
  display.setTextColor(WHITE);
  display.setCursor(26, 62);
  display.println(Display);
  

 
  // vertical battery bar, creates a full bar and creates a reverse overlay in black
  int Perc = map(analogRead(A2), 653, 873, 20, 0);  // // converts 6.8V (analog read 653) up to 8.8V (analog read 873) into 20bars displaying empty to full battery
  if (Perc > 20)
      {Bar = 20;}
  else {Bar = Perc;}  
  display.drawRect(90, 38, 10, 24, WHITE); //draw battery body outline
  display.fillRect(92, 40, 6, 20, WHITE); //fill battery with white (fulle battey)
  display.drawRect(92, 35, 6, 4, WHITE); //draw battery positive terminal
  display.fillRect(92, 40, 6, (Bar), BLACK); //draw a black portion over the white as the voltage is below 9V
  display.display(); 



toneAC (Frequency);      //Output to mixer
}
